def pbHashConverter(mod,hash)
  newhash = {}
  hash.each {|key, value|
      for i in value
          newhash[mod.const_get(i.to_sym)]=key
      end
  }
  return newhash
end

def pbHashForwardizer(hash) #one-stop shop for your hash debackwardsing needs!
  return if !hash.is_a?(Hash)
  newhash = {}
  hash.each {|key, value|
      for i in value
          newhash[i]=key
      end
  }
  return newhash
end

STATUSTEXTS = ["status", "sleep", "poison", "burn", "paralysis", "ice"]
STATSTRINGS = ["HP", "Attack", "Defense", "Sp. Attack", "Sp. Defense", "Speed"]

class PBStuff
  #rejuv stuff while we work out the kinks
  #massive arrays of stuff that no one wants to see
  #List of Abilities that either prevent or co-opt Intimidate
  TRACEABILITIES = [:PROTEAN,:CONTRARY,:INTIMIDATE, :WONDERGUARD,:MAGICGUARD,
    :SWIFTSWIM,:SLUSHRUSH, :SANDRUSH,:TELEPATHY,:SURGESURFER, :SOLARPOWER,:DRYSKIN,:DOWNLOAD, :LEVITATE,
    :LIGHTNINGROD,:MOTORDRIVE, :VOLTABSORB,:FLASHFIRE,:MAGMAARMOR, :ADAPTABILITY,:DEFIANT,:COMPETITIVE, 
    :PRANKSTER,:SPEEDBOOST,:MULTISCALE, :SHADOWSHIELD,:SAPSIPPER,:FURCOAT, :FLUFFY,:MAGICBOUNCE,
    :REGENERATOR, :DAZZLING,:QUEENLYMAJESTY,:SOUNDPROOF, :TECHNICIAN,:SPEEDBOOST,:STEAMENGINE, 
    :ICESCALES,:BEASTBOOST,:SHEDSKIN, :CLEARBODY,:WHITESMOKE,:MOODY, :THICKFAT,:STORMDRAIN,
    :SIMPLE,:PUREPOWER,:MARVELSCALE,:STURDY,:MEGALAUNCHER,:LIBERO,:SHEERFORCE,:UNAWARE,:CHLOROPHYLL]
  NEGATIVEABILITIES = [:TRUANT,:DEFEATIST,:SLOWSTART,:KLUTZ,:STALL,:GORILLATACTICS,:RIVALRY]

#Standardized lists of moves or abilities which are sometimes called
  #Blacklisted abilities USUALLY can't be copied.
###--------------------------------------ABILITYBLACKLIST-------------------------------------------------------###
ABILITYBLACKLIST = [:MULTITYPE,:COMATOSE,:DISGUISE,:SCHOOLING, 
  :RKSSYSTEM,:IMPOSTER,:SHIELDSDOWN,:POWEROFALCHEMY,:RECEIVER,:TRACE,:FORECAST,:FLOWERGIFT,
  :ILLUSION,:WONDERGUARD,:ZENMODE,:STANCECHANGE,:POWERCONSTRUCT,:ICEFACE,:ASONE,:NEUTRALIZINGGAS]

###--------------------------------------FIXEDABILITIES---------------------------------------------------------###
#Fixed abilities USUALLY can't be changed.
FIXEDABILITIES = [:MULTITYPE, :ZENMODE, :STANCECHANGE, :SCHOOLING, 
  :COMATOSE,:SHIELDSDOWN, :DISGUISE, :RKSSYSTEM, :POWERCONSTRUCT, :ICEFACE, :GULPMISSILE]

#Standardized lists of moves with similar purposes/characteristics
#(mostly just "stuff that gets called together")

###--------------------------------------UNFREEZEMOVE-----------------------------------------------------------###
UNFREEZEMOVE = [:FLAMEWHEEL,:SACREDFIRE,:FLAREBLITZ, :FUSIONFLARE, 
  :SCALD, :STEAMERUPTION, :BURNUP, :PYROBALL, :SCORCHINGSANDS]

###--------------------------------------SETUPMOVE--------------------------------------------------------------###
SETUPMOVE = [:SWORDSDANCE, :DRAGONDANCE, :CALMMIND, :WORKUP,:NASTYPLOT, 
  :TAILGLOW,:BELLYDRUM, :BULKUP,:COIL,:CURSE, :GROWTH, :HONECLAWS, :QUIVERDANCE, :SHELLSMASH, 
  :NORETREAT, :STUFFCHEEKS]

###--------------------------------------STATNERFMOVE-----------------------------------------------------------###
#moves with a 100% chance to lower an opponents stats on direct use (mainly for Lash Out AI stuff)
STATNERFMOVE = [:SCREECH, :METALSOUND, :FAKETEARS, :CHARM, :BABYDOLLEYES, :CAPTIVATE, :FEATHERDANCE,
  :EERIEIMPULSE, :NOBLEROAR, :PARTINGSHOT, :STRENGTHSAP, :DEFOG, :GROWL, :PLAYNICE, :TEARFULOOK,
  :TICKLE, :LEER, :TAILWHIP, :TARSHOT, :TOXICTHREAD, :COTTONSPORE, :STRINGSHOT, :SCARYFACE, :FLASH,
  :KINESIS, :SANDATTACK, :SMOKESCREEN, :BREAKINGSWIPE, :LUNGE, :FIRELASH, :GRAVAPPLE, :THUNDEROUSKICK,
  :MYSTICALFIRE, :SKITTERSMACK, :STRUGGLEBUG, :SPIRITBREAK, :APPLEACID, :ACIDSPRAY, :BULLDOZE,
  :DRUMBEATING, :GLACIATE, :ELECTROWEB, :ICYWIND, :MUDSHOT, :ROCKTOMB, :MUDSLAP]

###--------------------------------------PROTECTMOVE------------------------------------------------------------###
PROTECTMOVE = [:PROTECT, :DETECT,:KINGSSHIELD, :SPIKYSHIELD, :BANEFULBUNKER, :OBSTRUCT]

###--------------------------------------PROTECTIGNORINGMOVE----------------------------------------------------###
PROTECTIGNORINGMOVE = [:FEINT, :HYPERSPACEHOLE,:HYPERSPACEFURY, :SHADOWFORCE, :PHANTOMFORCE]

###--------------------------------------SCREENBREAKERMOVE------------------------------------------------------###
SCREENBREAKERMOVE = [:DEFOG, :BRICKBREAK,:PSYCHICFANGS]

###--------------------------------------CONTRARYBAITMOVE-------------------------------------------------------###
CONTRARYBAITMOVE = [:SUPERPOWER,:OVERHEAT,:DRACOMETEOR, :LEAFSTORM, 
  :FLEURCANNON, :PSYCHOBOOST]

###--------------------------------------TWOTURNAIRMOVE---------------------------------------------------------###
TWOTURNAIRMOVE = [:BOUNCE,:FLY, :SKYDROP]

###--------------------------------------PIVOTMOVE--------------------------------------------------------------###
PIVOTMOVE = [:UTURN, :VOLTSWITCH,:PARTINGSHOT, :FLIPTURN]

###--------------------------------------DANCEMOVE--------------------------------------------------------------###
DANCEMOVE = [:QUIVERDANCE, :DRAGONDANCE, :FIERYDANCE, 
  :FEATHERDANCE,:PETALDANCE,:SWORDSDANCE, :TEETERDANCE, :LUNARDANCE,:REVELATIONDANCE]

###--------------------------------------BULLETMOVE-------------------------------------------------------------###
BULLETMOVE = [:ACIDSPRAY, :AURASPHERE,:BARRAGE, :BULLETSEED,
  :EGGBOMB, :ELECTROBALL, :ENERGYBALL, :FOCUSBLAST,:GYROBALL,:ICEBALL, :MAGNETBOMB, 
  :MISTBALL,:MUDBOMB, :OCTAZOOKA, :ROCKWRECKER, :SEARINGSHOT, :SEEDBOMB,:SHADOWBALL,
  :SLUDGEBOMB, :WEATHERBALL, :ZAPCANNON, :BEAKBLAST, :PYROBALL]

###--------------------------------------BITEMOVE---------------------------------------------------------------###
BITEMOVE = [:BITE,:CRUNCH,:THUNDERFANG, :FIREFANG,:ICEFANG,
  :POISONFANG,:HYPERFANG, :PSYCHICFANGS, :FISHIOUSREND]

###--------------------------------------PHASEMOVE--------------------------------------------------------------###
PHASEMOVE = [:ROAR,:WHIRLWIND, :CIRCLETHROW, :DRAGONTAIL,:YAWN,:PERISHSONG]

###--------------------------------------SCREENMOVE-------------------------------------------------------------###
SCREENMOVE = [:LIGHTSCREEN, :REFLECT, :AURORAVEIL, :BADDYBAD, :GLITZYGLOW, :ARENITEWALL]

###--------------------------------------OHKOMOVE-------------------------------------------------------------###
OHKOMOVE = [:FISSURE,:SHEERCOLD,:GUILLOTINE,:HORNDRILL]

#Moves that inflict statuses with at least a 50% of hitting
###--------------------------------------BURNMOVE---------------------------------------------------------------###
BURNMOVE = [:WILLOWISP, :SACREDFIRE,:INFERNO, :SIZZLYSLIDE, :BURNINGJEALOUSY]

###--------------------------------------PARAMOVE---------------------------------------------------------------###
PARAMOVE = [:THUNDERWAVE, :STUNSPORE, :GLARE, :NUZZLE, :ZAPCANNON, :BUZZYBUZZ]

###--------------------------------------SLEEPMOVE--------------------------------------------------------------###
SLEEPMOVE = [:SPORE, :SLEEPPOWDER, :HYPNOSIS, :DARKVOID,:GRASSWHISTLE,
  :LOVELYKISS,:SING, :YAWN]

###--------------------------------------POISONMOVE-------------------------------------------------------------###
POISONMOVE = [:TOXIC, :POISONPOWDER,:POISONGAS, :TOXICTHREAD]

###--------------------------------------CONFUMOVE--------------------------------------------------------------###
CONFUMOVE = [:CONFUSERAY,:SUPERSONIC,:FLATTER, :SWAGGER, :SWEETKISS, 
  :TEETERDANCE, :CHATTER, :DYNAMICPUNCH]

# moves that are learned by almost all pokemon via TM/Tutor
###--------------------------------------NEAR-UNIVERSAL-TMS-----------------------------------------------------###
UNIVERSALTMS = [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,
  :NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC]

#all the status inflicting moves
###--------------------------------------STATUSCONDITIONMOVE----------------------------------------------------###
STATUSCONDITIONMOVE = [:WILLOWISP, :DARKVOID,:GRASSWHISTLE, :HYPNOSIS,
  :LOVELYKISS,:SING,:SLEEPPOWDER, :SPORE, :YAWN,:POISONGAS, :POISONPOWDER, :TOXIC, :NUZZLE,
  :STUNSPORE, :THUNDERWAVE, :SIZZLYSLIDE, :BUZZYBUZZ]


#Odd groups of moves/effects with similar behavior
###--------------------------------------HEALFUNCTIONS----------------------------------------------------------###
HEALFUNCTIONS =[0xD5,0xD6,0xD7,0xD8,0xD9,0xDD,0xDE,0xDF,0xE3,0xE4,0x114,0x139,0x158,0x162,0x169,0x16C,0x172,0x318]

###--------------------------------------RATESHARERS------------------------------------------------------------###
RATESHARERS = [:PROTECT, :DETECT,:QUICKGUARD, :WIDEGUARD, :ENDURE,
  :KINGSSHIELD, :SPIKYSHIELD, :BANEFULBUNKER, :CRAFTYSHIELD, :OBSTRUCT]

###--------------------------------------INVULEFFECTS-----------------------------------------------------------###
INVULEFFECTS = [:Protect, :Endure,:Obstruct, :KingsShield, :SpikyShield, :MatBlock]

###--------------------------------------POWDERMOVES------------------------------------------------------------###
POWDERMOVES = [:COTTONSPORE, :SLEEPPOWDER, :STUNSPORE, :SPORE, :RAGEPOWDER,
  :POISONPOWDER,:POWDER, :MAGICPOWDER]

###--------------------------------------AIRHITMOVES------------------------------------------------------------###
AIRHITMOVES = [:THUNDER, :HURRICANE, :GUST, :TWISTER, :SKYUPPERCUT, 
  :SMACKDOWN, :THOUSANDARROWS]

# Blacklist stuff
###--------------------------------------NOCOPYMOVE-------------------------------------------------------------###
NOCOPYMOVE = [:ASSIST,:COPYCAT, :MEFIRST, :METRONOME, :MIMIC, :MIRRORMOVE,
  :NATUREPOWER, :SHELLTRAP, :SKETCH,:SLEEPTALK, :STRUGGLE, :BEAKBLAST, :FOCUSPUNCH,:TRANSFORM, 
  :BELCH, :CHATTER, :KINGSSHIELD, :BANEFULBUNKER, :BESTOW, :COUNTER, :COVET, :DESTINYBOND, :DETECT, 
  :ENDURE,:FEINT, :FOLLOWME,:HELPINGHAND, :MATBLOCK,:MIRRORCOAT,:PROTECT, :RAGEPOWDER, :SNATCH,
  :SPIKYSHIELD, :SPOTLIGHT, :SWITCHEROO, :THIEF, :TRICK]

###--------------------------------------NOAUTOMOVE-------------------------------------------------------------###
NOAUTOMOVE = [:ASSIST,:COPYCAT, :MEFIRST, :METRONOME, :MIMIC, :MIRRORMOVE,
  :NATUREPOWER, :SHELLTRAP, :SKETCH,:SLEEPTALK, :STRUGGLE]

###--------------------------------------DELAYEDMOVE------------------------------------------------------------###
DELAYEDMOVE = [:BEAKBLAST, :FOCUSPUNCH]

###--------------------------------------TWOTURNMOVE------------------------------------------------------------###
TWOTURNMOVE = [:BOUNCE,:DIG, :DIVE, :FLY, :METEORBEAM, :PHANTOMFORCE,:SHADOWFORCE, :SKYDROP]

###--------------------------------------FORCEOUTMOVE-----------------------------------------------------------###
FORCEOUTMOVE = [:CIRCLETHROW, :DRAGONTAIL,:ROAR, :WHIRLWIND]
###--------------------------------------REPEATINGMOVE----------------------------------------------------------###
REPEATINGMOVE = [:ICEBALL, :OUTRAGE, :PETALDANCE, :ROLLOUT, :THRASH]

###--------------------------------------CHARGEMOVE-------------------------------------------------------------###
CHARGEMOVE = [:BIDE, :GEOMANCY,:RAZORWIND, :SKULLBASH,:SKYATTACK,:SOLARBEAM, 
  :SOLARBLADE, :FREEZESHOCK, :ICEBURN]

###---------------------------------------ITEMLISTS-------------------------------------------------------------###
HPITEMS = [:POTION, :SUPERPOTION, :ULTRAPOTION, :HYPERPOTION,:MAXPOTION,
  :FULLRESTORE, :BERRYJUICE, :RAGECANDYBAR, :SWEETHEART, :FRESHWATER,:SODAPOP, :LEMONADE, 
  :BUBBLETEA,:MEMEONADE, :MOOMOOMILK, :ENERGYPOWDER, :ENERGYROOT, :ORANBERRY, :SITRUSBERRY, 
  :CHOCOLATEIC,:VANILLAIC,:STRAWBIC,:BLUEMIC]

STATUSITEMS = [:FULLRESTORE,:PERSIMBERRY, :FULLHEAL, :MEDICINE, :LAVACOOKIE, 
  :OLDGATEAU, :CASTELIACONE, :HEALPOWDER, :LUMBERRY, :LUMIOSEGALETTE,:BIGMALASADA]

BURNITEMS = STATUSITEMS | [:BURNHEAL, :RAWSTBERRY, :SALTWATERTAFFY]

FREEZEITEMS = STATUSITEMS | [:ICEHEAL, :ASPEARBERRY, :REDHOTS]

PARAITEMS = STATUSITEMS | [:PARLYZHEAL, :CHERIBERRY, :CHEWINGGUM]

SLEEPITEMS = STATUSITEMS | [:AWAKENING, :CHESTOBERRY, :POPROCKS, :BLUEFLUTE]

POISONITEMS = STATUSITEMS | [:ANTIDOTE, :PECHABERRY, :PEPPERMINT]

CONFUITEMS = STATUSITEMS | [:PERSIMBERRY, :YELLOWFLUTE]

REVIVEITEMS = [:REVIVE,:MAXREVIVE,:REVIVALHERB,:COTTONCANDY]

PPITEMS = [:ETHER,:MAXETHER,:ELIXIR,:MAXELIXIR,:LEPPABERRY]

INFATUATIONITEMS =  [:REDFLUTE]

###-------------------------------------------------------------------------------------------------------------###

BLACKLISTS = {
:MEFIRST => NOCOPYMOVE | [:METALBURST],
###-------------------------------------------------------------------------------------------------------------###
:METRONOME => NOCOPYMOVE | [:AFTERYOU, 
  :DIAMONDSTORM,:FLEURCANNON, :HYPERSPACEFURY, :HYPERSPACEHOLE,:MINDBLOWN, :PHOTONGEYSER,:PLASMAFISTS,
  :QUASH, :QUICKGUARD,:RELICSONG, :SECRETSWORD, :SNORE, :SPECTRALTHIEF, :STEAMERUPTION, :TECHNOBLAST,
  :THOUSANDARROWS,:THOUSANDWAVES, :VCREATE, :WIDEGUARD, :CRAFTYSHIELD,:INSTRUCT,:FREEZESHOCK, 
  :ICEBURN, :WEATHERBALLSUN,:WEATHERBALLRAIN, :WEATHERBALLHAIL, :WEATHERBALLSAND, :SNARL, 
  :CELEBRATE, :TECHNOBLASTELECTRIC, :TECHNOBLASTFIRE, :TECHNOBLASTICE, :TECHNOBLASTWATER,
  :MULTIATTACKBUG, :MULTIATTACKDARK, :MULTIATTACKDRAGON, :MULTIATTACKELECTRIC, :MULTIATTACKFAIRY,
  :MULTIATTACKFIGHTING, :MULTIATTACKFIRE, :MULTIATTACKFLYING, :MULTIATTACKGHOST, :MULTIATTACKGLITCH,
  :MULTIATTACKGRASS, :MULTIATTACKGROUND, :MULTIATTACKICE, :MULTIATTACKPOISON, :MULTIATTACKPSYCHIC,
  :MULTIATTACKROCK, :MULTIATTACKSTEEL, :MULTIATTACKWATER,
  :JUDGMENTBUG, :JUDGMENTDARK, :JUDGMENTDRAGON, :JUDGMENTELECTRIC, :JUDGMENTFAIRY,
  :JUDGMENTFIGHTING, :JUDGMENTFIRE, :JUDGMENTFLYING, :JUDGMENTGHOST, :JUDGMENTQMARKS,
  :JUDGMENTGRASS, :JUDGMENTGROUND, :JUDGMENTICE, :JUDGMENTPOISON, :JUDGMENTPSYCHIC,
  :JUDGMENTROCK, :JUDGMENTSTEEL, :JUDGMENTWATER, :HIDDENPOWERNOR, :HIDDENPOWERFIR, :HIDDENPOWERFIG,
  :HIDDENPOWERWAT, :HIDDENPOWERFLY, :HIDDENPOWERGRA, :HIDDENPOWERPOI, :HIDDENPOWERELE, :HIDDENPOWERGRO,
  :HIDDENPOWERPSY, :HIDDENPOWERROC, :HIDDENPOWERICE, :HIDDENPOWERBUG, :HIDDENPOWERDRA, :HIDDENPOWERGHO,
  :HIDDENPOWERDAR, :HIDDENPOWERSTE, :HIDDENPOWERFAI, :FUTUREDUMMY, :DOOMDUMMY, :SPLINTERSDARK, :SPLINTERSROCK],

###-------------------------------------------------------------------------------------------------------------###
:COPYCAT => NOCOPYMOVE | FORCEOUTMOVE | [:CRAFTYSHIELD],
###-------------------------------------------------------------------------------------------------------------###
:ASSIST =>NOCOPYMOVE | FORCEOUTMOVE | TWOTURNMOVE,
###-------------------------------------------------------------------------------------------------------------###
:INSTRUCT =>NOAUTOMOVE | DELAYEDMOVE | TWOTURNMOVE | REPEATINGMOVE |
[:TRANSFORM,:BELCH, :KINGSSHIELD, :BIDE, :INSTRUCT],
###-------------------------------------------------------------------------------------------------------------###
:SLEEPTALK => NOAUTOMOVE | DELAYEDMOVE | TWOTURNMOVE | CHARGEMOVE | [:BELCH,:CHATTER],
###-------------------------------------------------------------------------------------------------------------###
:ENCORE =>NOAUTOMOVE | [:TRANSFORM]
}

#massive arrays of stuff that no one wants to see
NATURALGIFTDAMAGE=pbHashForwardizer({
###-------------------------------------------------------------------------------------------------------------###
  100 => [:WATMELBERRY, :DURINBERRY,  :BELUEBERRY,  :LIECHIBERRY, :GANLONBERRY, :SALACBERRY,
          :PETAYABERRY, :APICOTBERRY, :LANSATBERRY, :STARFBERRY,  :ENIGMABERRY, :MICLEBERRY,
          :CUSTAPBERRY, :JABOCABERRY, :ROWAPBERRY],
###-------------------------------------------------------------------------------------------------------------###
   90 => [:BLUKBERRY,   :NANABBERRY,  :WEPEARBERRY, :PINAPBERRY,  :POMEGBERRY,  :KELPSYBERRY,
          :QUALOTBERRY, :HONDEWBERRY, :GREPABERRY,  :TAMATOBERRY, :CORNNBERRY,  :MAGOSTBERRY,
          :RABUTABERRY, :NOMELBERRY,  :SPELONBERRY, :PAMTREBERRY],
###-------------------------------------------------------------------------------------------------------------###
   80 => [:CHERIBERRY,  :CHESTOBERRY, :PECHABERRY,  :RAWSTBERRY,  :ASPEARBERRY, :LEPPABERRY,
          :ORANBERRY,   :PERSIMBERRY, :LUMBERRY,    :SITRUSBERRY, :FIGYBERRY,   :WIKIBERRY,
          :MAGOBERRY,   :AGUAVBERRY,  :IAPAPABERRY, :RAZZBERRY,   :OCCABERRY,   :PASSHOBERRY,
          :WACANBERRY,  :RINDOBERRY,  :YACHEBERRY,  :CHOPLEBERRY, :KEBIABERRY,  :SHUCABERRY,
          :COBABERRY,   :PAYAPABERRY, :TANGABERRY,  :CHARTIBERRY, :KASIBBERRY,  :HABANBERRY,
          :COLBURBERRY, :BABIRIBERRY, :CHILANBERRY]})
###-------------------------------------------------------------------------------------------------------------###
NATURALGIFTTYPE=pbHashForwardizer({
  :NORMAL   => [:CHILANBERRY],
  :FIRE     => [:CHERIBERRY,  :BLUKBERRY,   :WATMELBERRY, :OCCABERRY],
  :WATER    => [:CHESTOBERRY, :NANABBERRY,  :DURINBERRY,  :PASSHOBERRY],
  :ELECTRIC => [:PECHABERRY,  :WEPEARBERRY, :BELUEBERRY,  :WACANBERRY],
  :GRASS    => [:RAWSTBERRY,  :PINAPBERRY,  :RINDOBERRY,  :LIECHIBERRY],
  :ICE      => [:ASPEARBERRY, :POMEGBERRY,  :YACHEBERRY,  :GANLONBERRY],
  :FIGHTING => [:LEPPABERRY,  :KELPSYBERRY, :CHOPLEBERRY, :SALACBERRY],
  :POISON   => [:ORANBERRY,   :QUALOTBERRY, :KEBIABERRY,  :PETAYABERRY],
  :GROUND   => [:PERSIMBERRY, :HONDEWBERRY, :SHUCABERRY,  :APICOTBERRY],
  :FLYING   => [:LUMBERRY,    :GREPABERRY,  :COBABERRY,   :LANSATBERRY],
  :PSYCHIC  => [:SITRUSBERRY, :TAMATOBERRY, :PAYAPABERRY, :STARFBERRY],
  :BUG      => [:FIGYBERRY,   :CORNNBERRY,  :TANGABERRY,  :ENIGMABERRY],
  :ROCK     => [:WIKIBERRY,   :MAGOSTBERRY, :CHARTIBERRY, :MICLEBERRY],
  :GHOST    => [:MAGOBERRY,   :RABUTABERRY, :KASIBBERRY,  :CUSTAPBERRY],
  :DRAGON   => [:AGUAVBERRY,  :NOMELBERRY,  :HABANBERRY,  :JABOCABERRY],
  :DARK     => [:IAPAPABERRY, :SPELONBERRY, :COLBURBERRY, :ROWAPBERRY],
  :FAIRY    => [:ROSELIBERRY, :KEEBERRY],
  :STEEL    => [:RAZZBERRY,   :PAMTREBERRY,:BABIRIBERRY]})
FLINGDAMAGE=pbHashForwardizer({
  300 => [:MEMEONADE],
  130 => [:IRONBALL],
  100 => [:ARMORFOSSIL,:CLAWFOSSIL,:COVERFOSSIL,:DOMEFOSSIL,:HARDSTONE,:HELIXFOSSIL,
          :OLDAMBER,:PLUMEFOSSIL,:RAREBONE,:ROOTFOSSIL,:SKULLFOSSIL],
   90 => [:DEEPSEATOOTH,:DRACOPLATE,:DREADPLATE,:EARTHPLATE,:FISTPLATE,:FLAMEPLATE,
          :GRIPCLAW,:ICICLEPLATE,:INSECTPLATE,:IRONPLATE,:MEADOWPLATE,:MINDPLATE,
          :SKYPLATE,:SPLASHPLATE,:SPOOKYPLATE,:STONEPLATE,:THICKCLUB,:TOXICPLATE,
          :ZAPPLATE],
   80 => [:DAWNSTONE,:DUSKSTONE,:ELECTIRIZER,:MAGMARIZER,:ODDKEYSTONE,:OVALSTONE,
          :PROTECTOR,:QUICKCLAW,:RAZORCLAW,:SHINYSTONE,:STICKYBARB,:ASSAULTVEST],
   70 => [:BURNDRIVE,:CHILLDRIVE,:DOUSEDRIVE,:DRAGONFANG,:POISONBARB,:POWERANKLET,
          :POWERBAND,:POWERBELT,:POWERBRACER,:POWERLENS,:POWERWEIGHT,:SHOCKDRIVE],
   60 => [:ADAMANTORB,:DAMPROCK,:HEATROCK,:LUSTROUSORB,:MACHOBRACE,:ROCKYHELMET,
          :STICK,:AMPLIFIELDROCK,:ADRENALINEORB],
   50 => [:DUBIOUSDISC,:SHARPBEAK],
   40 => [:EVIOLITE,:ICYROCK,:LUCKYPUNCH,:PROTECTIVEPADS],
   30 => [:ABILITYURGE,:ABSORBBULB,:AMULETCOIN,:ANTIDOTE,:AWAKENING,:BALMMUSHROOM,
          :BERRYJUICE,:BIGMUSHROOM,:BIGNUGGET,:BIGPEARL,:BINDINGBAND,:BLACKBELT,
          :BLACKFLUTE,:BLACKGLASSES,:BLACKSLUDGE,:BLUEFLUTE,:BLUESHARD,:BUBBLETEA,:BURNHEAL,
          :CALCIUM,:CARBOS,:CASTELIACONE,:CELLBATTERY,:CHARCOAL,:CLEANSETAG,
          :COMETSHARD,:DAMPMULCH,:DEEPSEASCALE,:DIREHIT,
          :DRAGONSCALE,:EJECTBUTTON,:ELIXIR,:ENERGYPOWDER,:ENERGYROOT,:ESCAPEROPE,
          :ETHER,:EVERSTONE,:EXPSHARE,:FIRESTONE,:FLAMEORB,:FLOATSTONE,:FLUFFYTAIL,
          :FRESHWATER,:FULLHEAL,:FULLRESTORE,:GOOEYMULCH,:GREENSHARD,:GROWTHMULCH,
          :GUARDSPEC,:HEALPOWDER,:HEARTSCALE,:HONEY,:HPUP,:HYPERPOTION,:ICEHEAL,
          :IRON,:ITEMDROP,:ITEMURGE,:KINGSROCK,:LAVACOOKIE,:LEAFSTONE,:LEMONADE,
          :LIFEORB,:LIGHTBALL,:LIGHTCLAY,:LUCKYEGG,:MAGNET,:MAGNETICLURE,:MAXELIXIR,:MAXETHER,
          :MAXPOTION,:MAXREPEL,:MAXREVIVE,:MEDICINE,:METALCOAT,:METRONOME,:MIRACLESEED,
          :MOOMOOMILK,:MOONSTONE,:MYSTICWATER,:NEVERMELTICE,:NUGGET,:OLDGATEAU,
          :PARLYZHEAL,:PEARL,:PEARLSTRING,:POKEDOLL,:POKETOY,:POTION,:PPALL,:PPMAX,:PPUP,
          :PRISMSCALE,:PROTEIN,:RAGECANDYBAR,:RARECANDY,:RAZORFANG,:REDFLUTE,
          :REDSHARD,:RELICBAND,:RELICCOPPER,:RELICCROWN,:RELICGOLD,:RELICSILVER,
          :RELICSTATUE,:RELICVASE,:REPEL,:RESETURGE,:REVIVALHERB,:REVIVE,:SACREDASH,
          :SCOPELENS,:SHELLBELL,:SHOALSALT,:SHOALSHELL,:SMOKEBALL,:SODAPOP,:SOULDEW,
          :SPELLTAG,:STABLEMULCH,:STARDUST,:STARPIECE,:SUNSTONE,:SUPERPOTION,
          :SUPERREPEL,:SWEETHEART,:THUNDERSTONE,:TINYMUSHROOM,:TOXICORB,
          :TWISTEDSPOON,:UPGRADE,:WATERSTONE,:WHITEFLUTE,:XACCURACY,:XATTACK,:XDEFEND,
          :XSPDEF,:XSPECIAL,:XSPEED,:YELLOWFLUTE,:YELLOWSHARD,:ZINC,:BIGMALASADA,:ICESTONE],
   20 => [:CLEVERWING,:GENIUSWING,:HEALTHWING,:MUSCLEWING,:PRETTYWING,
          :RESISTWING,:SWIFTWING],
   10 => [:AIRBALLOON,:BIGROOT,:BLUESCARF,:BRIGHTPOWDER,:CHOICEBAND,:CHOICESCARF,
          :CHOICESPECS,:DESTINYKNOT,:EXPERTBELT,:FOCUSBAND,:FOCUSSASH,:FULLINCENSE,
          :GREENSCARF,:LAGGINGTAIL,:LAXINCENSE,:LEFTOVERS,:LUCKINCENSE,:MENTALHERB,
          :METALPOWDER,:MUSCLEBAND,:ODDINCENSE,:PINKSCARF,:POWERHERB,:PUREINCENSE,
          :QUICKPOWDER,:REAPERCLOTH,:REDCARD,:REDSCARF,:RINGTARGET,:ROCKINCENSE,
          :ROSEINCENSE,:SEAINCENSE,:SHEDSHELL,:SILKSCARF,:SILVERPOWDER,:SMOOTHROCK,
          :SOFTSAND,:SOOTHEBELL,:WAVEINCENSE,:WHITEHERB,:WIDELENS,:WISEGLASSES,
          :YELLOWSCARF,:ZOOMLENS,:BLUEMIC,:VANILLAIC,:STRAWBIC,:CHOCOLATEIC]})

  STATUSDAMAGE = pbHashForwardizer({
   0 => [:AFTERYOU,     :BESTOW,          :CRAFTYSHIELD,:LUCKYCHANT,:MEMENTO,:QUASH,:SAFEGUARD,
         :SPITE,        :SPLASH,          :SWEETSCENT,:TELEKINESIS,:TELEPORT],
   5 => [:ALLYSWITCH,   :AROMATICMIST,    :CAMOUFLAGE, :CONVERSION,:ENDURE,:ENTRAINMENT,:FLOWERSHIELD,
         :FORESIGHT,    :FORESTSCURSE,    :GRAVITY,:DEFOG,:GUARDSWAP,:HEALBLOCK,:IMPRISON,
         :INSTRUCT,     :FAIRYLOCK,       :LASERFOCUS,:HELPINGHAND,:MAGICROOM,:MAGNETRISE,:SOAK,
         :LOCKON,       :MINDREADER,      :MIRACLEEYE,:MUDSPORT,:NIGHTMARE,:ODORSLEUTH,:POWERSPLIT,
         :POWERSWAP,    :GRUDGE,          :GUARDSPLIT,:POWERTRICK,:QUICKGUARD,:RECYCLE,:REFLECTTYPE,
         :ROTOTILLER,   :SKILLSWAP,       :SNATCH,:MAGICCOAT,:SPEEDSWAP,:SPOTLIGHT,
         :SWALLOW,      :TEETERDANCE,     :WATERSPORT,:WIDEGUARD,:WONDERROOM, :MAGICPOWDER, :TEATIME],
  10 => [:ACIDARMOR,    :ACUPRESSURE,     :AGILITY,:AMNESIA,:AUTOTOMIZE,:BABYDOLLEYES,:BARRIER,:BELLYDRUM,:BULKUP,
         :CALMMIND,     :CAPTIVATE,:CHARGE,:CHARM,:COIL,:CONFIDE,:COSMICPOWER,:COTTONGUARD,
         :COTTONSPORE,  :CURSE,           :DEFENDORDER,:DEFENSECURL,:DRAGONDANCE,:DOUBLETEAM,:EERIEIMPULSE,:EMBARGO,
         :FAKETEARS,    :FEATHERDANCE,    :FLASH,:FOCUSENERGY,:GEOMANCY,:GROWL,:GROWTH,:GEARUP,:HARDEN,:HAZE,
         :HONECLAWS,    :HOWL,            :IRONDEFENSE,:KINESIS,:LEER,:MAGNETICFLUX,:MEDITATE,:METALSOUND,:MINIMIZE, :NASTYPLOT,
         :NOBLEROAR,    :PLAYNICE,        :POWDER,:PSYCHUP,:PROTECT,:QUIVERDANCE,:ROCKPOLISH,:SANDATTACK,:SCARYFACE,:SCREECH,
         :SHARPEN,      :SHELLSMASH,      :SHIFTGEAR,:SMOKESCREEN, :STOCKPILE, :STRINGSHOT,:SUPERSONIC,:SWORDSDANCE,:TAILGLOW,
         :TAILWHIP,     :TEARFULLOOK,     :TICKLE,:TORMENT,:VENOMDRENCH,:WISH,:WITHDRAW,:WORKUP, :TARSHOT, :CLANGOROUSSOUL,
         :DECORATE, :COACHING],
  15 => [:ASSIST,       :BATONPASS,       :DARKVOID, :FLORALHEALING,:GRASSWHISTLE,:HEALPULSE, :HEALINGWISH,:HYPNOSIS,:INGRAIN,
         :LUNARDANCE,   :MEFIRST,:MIMIC,  :PARTINGSHOT,:POISONPOWDER,:REFRESH,:ROLEPLAY,:SING, :SKETCH,
         :TRICKORTREAT, :TOXICTHREAD,     :SANDSTORM,:HAIL,:SUNNYDAY,:RAINDANCE, :LIFEDEW],
  20 => [:AQUARING,     :BLOCK,           :CONVERSION2, :DETECT, :ELECTRIFY,:FLATTER,:GASTROACID,:HEALORDER, :HEARTSWAP,
         :IONDELUGE,    :MEANLOOK,        :LOVELYKISS,:MILKDRINK,:METRONOME,:MOONLIGHT,  :MORNINGSUN,:COPYCAT,:MIRRORMOVE,:MIST,
         :PERISHSONG,   :RECOVER, :REST,:ROAR,     :ROOST, :SIMPLEBEAM,:SHOREUP,:SPIDERWEB,
         :SLEEPPOWDER,  :SLACKOFF,        :SOFTBOILED,:STRENGTHSAP, :SWAGGER, 
         :SWEETKISS,    :SYNTHESIS,        :POISONGAS, :TRANSFORM,:WHIRLWIND,:WORRYSEED,:YAWN, :JUNGLEHEALING],
  25 => [:ATTRACT,      :CONFUSERAY,      :DESTINYBOND, :DISABLE,:FOLLOWME, :LEECHSEED,
         :PAINSPLIT,    :PSYCHOSHIFT,:RAGEPOWDER, :STUNSPORE,
         :SUBSTITUTE,   :SWITCHEROO,      :TAUNT,:TOPSYTURVY, :TOXIC,:TRICK,:WILLOWISP, :CORROSIVEGAS, :OCTOLOCK],
  30 => [:ELECTRICTERRAIN, :ENCORE,:GLARE,
         :GRASSYTERRAIN,:MISTYTERRAIN,    :NATUREPOWER,:PSYCHICTERRAIN,:PURIFY,:SLEEPTALK,
         :SPIKES,       :STEALTHROCK,     :SPIKYSHIELD,:THUNDERWAVE,:TOXICSPIKES,:TRICKROOM],
  35 => [:AROMATHERAPY, :BANEFULBUNKER,   :HEALBELL,:KINGSSHIELD,:LIGHTSCREEN,:MATBLOCK,
         :REFLECT,      :TAILWIND, :OBSTRUCT, :STUFFCHEEKS, :NORETREAT, :COURTCHANG],
  40 => [],
  60 => [:AURORAVEIL,:STICKYWEB,:SPORE]})

TYPETOZCRYSTAL= {
  :NORMAL     => :NORMALIUMZ,    :FIGHTING   => :FIGHTINIUMZ,
  :FLYING     => :FLYINIUMZ,     :POISON     => :POISONIUMZ, 
  :GROUND     => :GROUNDIUMZ,    :ROCK       => :ROCKIUMZ,
  :BUG        => :BUGINIUMZ,     :GHOST      => :GHOSTIUMZ,
  :STEEL      => :STEELIUMZ,     :FIRE       => :FIRIUMZ, 
  :WATER      => :WATERIUMZ,     :GRASS      => :GRASSIUMZ, 
  :ELECTRIC   => :ELECTRIUMZ,    :PSYCHIC    => :PSYCHIUMZ,
  :ICE        => :ICIUMZ,        :DRAGON     => :DRAGONIUMZ, 
  :DARK       => :DARKINIUMZ,    :FAIRY      => :FAIRIUMZ 
}

POKEMONTOMEGASTONE = {
  :CHARIZARD  => [:CHARIZARDITEX, :CHARIZARDITEY, :CHARIZARDITEG],
  :MEWTWO     => [:MEWTWONITEX, :MEWTWONITEY],
  :VENUSAUR   => [:VENUSAURITE, :VENUSAURITEG],
  :BLASTOISE  => [:BLASTOISINITE, :BLASTOISINITEG],
  :GENGAR     => [:GENGARITE, :GENGARITEG],
  :ABOMASNOW  => [:ABOMASITE],      :ABSOL      => [:ABSOLITE],
  :AERODACTYL => [:AERODACTYLITE],  :AGGRON     => [:AGGRONITE],
  :ALAKAZAM   => [:ALAKAZITE],      :AMPHAROS   => [:AMPHAROSITE],
  :BANETTE    => [:BANETTITE],      :BLAZIKEN   => [:BLAZIKENITE],
  :GARCHOMP   => [:GARCHOMPITE],    :GARDEVOIR  => [:GARDEVOIRITE],
  :GYARADOS   => [:GYARADOSITE],    :HERACROSS  => [:HERACRONITE],
  :HOUNDOOM   => [:HOUNDOOMINITE],  :KANGASKHAN => [:KANGASKHANITE],
  :LUCARIO    => [:LUCARIONITE],    :MANECTRIC  => [:MANECTITE],
  :MAWILE     => [:MAWILITE],       :MEDICHAM   => [:MEDICHAMITE],
  :PINSIR     => [:PINSIRITE],      :SCIZOR     => [:SCIZORITE],
  :TYRANITAR  => [:TYRANITARITE],   :BEEDRILL   => [:BEEDRILLITE],
  :PIDGEOT    => [:PIDGEOTITE],     :SLOWBRO    => [:SLOWBRONITE],
  :STEELIX    => [:STEELIXITE],     :SCEPTILE   => [:SCEPTILITE],
  :SWAMPERT   => [:SWAMPERTITE],    :SHARPEDO   => [:SHARPEDONITE],
  :SABLEYE    => [:SABLENITE],      :CAMERUPT   => [:CAMERUPTITE],
  :ALTARIA    => [:ALTARIANITE],    :GLALIE     => [:GLALITITE],
  :SALAMENCE  => [:SALAMENCITE],    :METAGROSS  => [:METAGROSSITE],
  :LOPUNNY    => [:LOPUNNITE],      :GALLADE    => [:GALLADITE],
  :AUDINO     => [:AUDINITE],       :DIANCIE    => [:DIANCITE],
  :LATIAS     => [:LATIASITE],      :LATIOS     => [:LATIOSITE],
  # Reborn thing
  :TANGROWTH  => [:PULSEHOLD],
  # Gmax Megas
  :BUTTERFREE => [:BUTTERFREENITE], :MACHAMP    => [:MACHAMPITE],
  :PIKACHU    => [:PIKACHUTITE],    :MEOWTH     => [:MEOWTHITE],
  :KINGLER    => [:KINGLERITE],     :LAPRAS     => [:LAPRASITE],
  :EEVEE      => [:EEVEETITE],      :SNORLAX    => [:SNORLAXITE],
  :GARBODOR   => [:GARBODORNITE],   :MELMETAL   => [:MELMETALITE],
  :CORVIKNIGHT=> [:CORVIKNITE],     :ORBEETLE   => [:ORBEETLENITE],
  :DREDNAWTITE=> [:DREDNAWTITE],    :COALOSSAL  => [:COALOSSALITE],
  :FLAPPLE    => [:FLAPPLETITE],    :APPLETUN   => [:APPLETUNITE],
  :SANDACONDA => [:SANDACONDITE],   :TOXTRICITY => [:TOXTRICITITE],
  :CENTISKORCH=> [:CENTISKORCHITE], :HATTERENE  => [:HATTERENITE],
  :GRIMMSNARL => [:GRIMMSNARLITE],  :ALCREMIE   => [:ALCREMITE],
  :COPPERAJAH => [:COPPERAJITE],    :DURALUDON  => [:DURALUDONITE],
  :RILLABOOM  => [:RILLABOOMITE],   :INTELEON   => [:INTELEONITE],
  :CINDERACE  => [:CINDERACITE],    :URSHIFU    => [:URSHIFUTITE],
  # Deso Megas
  :MIGHTYENA  => [:MIGHTYENITE],    :FERALIGATR  => [:FERALIGATRITE],
  :LUXRAY     => [:LUXRITE],        :CINCCINO    => [:CINCCINITE],
  :TOXICROAK    => [:TOXICROAKITE],
}

POKEMONTOCREST = {
  :TYPHLOSION  => :TYPHCREST,         :ARIADOS   => :ARIACREST,
  :FERALIGATR   => :FERACREST,        :DEDENNE   => :DEDECREST,
  :MEGANIUM   => :MEGCREST,           :MAGCARGO   => :MAGCREST,
  :BEHEEYEM  =>  :BEHECREST,          :VESPIQUEN => :VESPICREST,
  :GLACEON => :GLACCREST,             :LEAFEON     => :LEAFCREST,
  :FEAROW   => :FEARCREST,            :DUSKNOIR   => :DUSKCREST,
  :STANTLER    => :STANTCREST,        :HYPNO   => :HYPCREST,
  :RELICANTH   => :RELICREST,         :ORICORIO  => :ORICREST,
  :SILVALLY     => :SILVCREST,        :SEVIPER   => :SEVCREST,
  :COFAGRIGUS  => :COFCREST,          :SKUNTANK   => :SKUNCREST,
  :WHISCASH => :WHISCREST,            :DARMANITAN    => :DARMCREST,
  :CHERRIM  => :CHERCREST,            :CLAYDOL     => :CLAYCREST,
  :ZANGOOSE   => :ZANGCREST,          :RAMPARDOS     => :RAMPCREST,  
  :LEDIAN     => :LEDICREST,          :SPIRITOMB  => :SPIRITCREST,
  :TORTERRA   => :TORCREST,           :EMPOLEON    => :EMPCREST,
  :INFERNAPE    => :INFCREST,         :CASTFORM    => :CASTCREST,
  :BOLTUND   => :BOLTCREST,           :THIEVUL   => :THIEVCREST,
  :LUXRAY   => :LUXCREST,             :NOCTOWL    => :NOCCREST,
  :DRUDDIGON   => :DRUDDICREST,       :PHIONE    => :PHIONECREST,
  :DELCATTY     => :DELCREST,         :SWALOT  => :SWACREST,
  :CINCCINO  => :CINCCREST,           :PROBOPASS    => :PROBOCREST,
  :BASTIODON => :BASTCREST,
}

SILVALLYCRESTABILITIES = {
  :GRASSMEMORY => :FLOWERVEIL,  :FIREMEMORY => :MOXIE,
  :WATERMEMORY => :MARVELSCALE, :FIGHTINGMEMORY => :DEFIANT,
  :FLYINGMEMORY => :GALEWINGS,  :ROCKMEMORY => :SOLIDROCK,
  :ELECTRICMEMORY => :DOWNLOAD, :PSYCHICMEMORY => :MAGICBOUNCE,
  :GHOSTMEMORY => :MUMMY,       :POISONMEMORY => :REGENERATOR,
  :DRAGONMEMORY => :MULTISCALE, :GROUNDMEMORY => :SHEERFORCE,
  :STEELMEMORY => :HEATPROOF,   :DARKMEMORY => :STRONGJAW,
  :ICEMEMORY => :THICKFAT,      :BUGMEMORY => :TINTEDLENS,
  :FAIRYMEMORY => :UNAWARE,   
}

POKEMONTOMEGASTONE.default = []
POKEMONTOCREST.default = []
SILVALLYCRESTABILITIES.default = []

LEGENDARYLIST =      [:CRESSELIA,     :REGICE,      :REGIROCK,
  :REGISTEEL,         :SUICUNE,       :ENTEI,       :RAIKOU,
  :MESPRIT,           :AZELF,         :UXIE,        :ARTICUNO,
  :ZAPDOS,            :MOLTRES,       :LANDORUS,    :THUNDURUS,
  :TORNADUS,          :TERRAKION,     :VIRIZION,    :COBALION,
  :KELDEO,            :REGIGIGAS,     :CELEBI,      :MELOETTA,
  :VICTINI,           :VOLCANION,     :HOOPA,       :ZERAORA,
  :MAGEARNA,          :ZYGARDE,       :TAPUBULU,    :TAPUKOKO,
  :TAPULELE,          :TAPUFINI,      :DIANCIE,     :JIRACHI,
  :HEATRAN,           :LATIAS,        :LATIOS,      :MANAPHY,
  :DARKRAI,           :MARSHADOW,     :SHAYMIN,     :MEW,
  :GENESECT,          :DIALGA,        :PALKIA,      :HOOH,
  :LUGIA,             :RESHIRAM,      :ZEKROM,      :KYUREM,
  :XERNEAS,           :YVELTAL,       :COSMOG,      :COSMOEM,
  :LUNALA,            :SOLGALEO,      :DEOXYS,      :GROUDON,
  :KYOGRE,            :GIRATINA,      :RAYQUAZA,    :NECROZMA,  
  :MEWTWO,            :ARCEUS,        :MELTAN,      :MELMETAL,
  :ZACIAN,            :ZAMAZENTA,     :ETERNATUS,   :KUBFU,
  :URSHIFU,           :ZARUDE,        :REGIELEKI,   :REGIDRAGO,
  :GLASTRIER,         :SPECTRIER,     :CALYREX,     :ENAMORUS,
  :TYPENULL,          :SILVALLY  ]

ULTRABEASTS = [:NIHILEGO, :BUZZWOLE, :PHEROMOSA, :XURKITREE, :CELESTEELA, :KARTANA,
               :GUZZLORD, :POIPOLE,  :NAGANADEL, :STAKATAKA, :BLACEPHALON]

SHORTCIRCUITROLLS = [0.8, 1.5, 0.5, 1.2, 2.0]

CCROLLS = [:FIRE, :WATER, :GRASS, :PSYCHIC]

CROWDBUFFS = [
  "(self.attack > self.spatk) ? self.pbIncreaseStatBasic(PBStats::ATTACK,1) : self.pbIncreaseStatBasic(PBStats::SPATK,1); @battle.pbCommonAnimation(\"StatUp\",self,nil);",
  "(self.defense > self.spdef) ?  self.pbIncreaseStatBasic(PBStats::DEFENSE,1) : self.pbIncreaseStatBasic(PBStats::SPDEF,1); @battle.pbCommonAnimation(\"StatUp\",self,nil);",
  "self.pbIncreaseStatBasic(PBStats::SPEED,1); @battle.pbCommonAnimation(\"StatUp\",self,nil);",
  ]
CROWDDEBUFFS = [
  "(self.attack > self.spatk) ? self.pbReduceStatBasic(PBStats::ATTACK,1) : self.pbReduceStatBasic(PBStats::SPATK,1); @battle.pbCommonAnimation(\"StatDown\",self,nil);",
  "(self.defense > self.spdef) ?  self.pbReduceStatBasic(PBStats::DEFENSE,1) : self.pbReduceStatBasic(PBStats::SPDEF,1); @battle.pbCommonAnimation(\"StatDown\",self,nil);",
  "self.pbReduceStatBasic(PBStats::SPEED,1); @battle.pbCommonAnimation(\"StatDown\",self,nil);",
  ]
end

class PBFields
  #PBStuff for field effects.

	STRIKERMOVES = [:STRENGTH, :WOODHAMMER, :DUALCHOP, :HEATCRASH, :SKYDROP, 
    :BULLDOZE, :POUND, :ICICLECRASH, :BODYSLAM, :STOMP, :SLAM, :GIGAIMPACT, :SMACKDOWN, :IRONTAIL, 
    :METEORMASH, :DRAGONRUSH, :CRABHAMMER, :BOUNCE, :HEAVYSLAM, :MAGNITUDE, :EARTHQUAKE, 
    :STOMPINGTANTRUM, :BRUTALSWING, :HIGHHORSEPOWER, :ICEHAMMER, :DRAGONHAMMER, :BLAZEKICK,
    :GRAVAPPLE, :DOUBLEIRONBASH, :CONTINENTALCRUSH]

	WINDMOVES = [:OMINOUSWIND, :ICYWIND, :SILVERWIND, :TWISTER, :RAZORWIND, 
    :FAIRYWIND, :GUST]

	MIRRORMOVES = [:CHARGEBEAM, :SOLARBEAM, :PSYBEAM, :TRIATTACK, 
    :BUBBLEBEAM, :HYPERBEAM, :ICEBEAM, :ORIGINPULSE, :MOONGEISTBEAM, :FLEURCANNON]

	BLINDINGMOVES = [:AURORABEAM, :SIGNALBEAM, :FLASHCANNON, :LUSTERPURGE, 
    :DAZZLINGGLEAM, :TECHNOBLAST, :DOOMDUMMY, :PRISMATICLASER, :PHOTONGEYSER, :LIGHTTHATBURNSTHESKY]

	IGNITEMOVES = [:HEATWAVE, :ERUPTION, :SEARINGSHOT, :FLAMEBURST, 
    :LAVAPLUME, :FIREPLEDGE, :MINDBLOWN, :INCINERATE, :INFERNOOVERDRIVE]

	BLOWMOVES = [:WHIRLWIND, :GUST, :RAZORWIND, :DEFOG, :HURRICANE, 
    :TWISTER,:TAILWIND, :SUPERSONICSKYSTRIKE]

	GROWMOVES = [:GROWTH,:FLOWERSHIELD,:RAINDANCE,:SUNNYDAY, :ROTOTILLER,
    :INGRAIN,:WATERSPORT]

	MAXGARDENMOVES = PBStuff::POWDERMOVES + [:PETALDANCE,:PETALBLIZZARD]

	QUAKEMOVES = [:EARTHQUAKE, :BULLDOZE, :MAGNITUDE, :FISSURE, :TECTONICRAGE]
  
  # Multi-stage Fields
  FLOWERGARDEN = [:FLOWERGARDEN1,:FLOWERGARDEN2,:FLOWERGARDEN3,:FLOWERGARDEN4,:FLOWERGARDEN5]
  DARKNESS = [:DARKNESS1,:DARKNESS2,:DARKNESS3] #desolation
  CONCERT = [:CONCERT1,:CONCERT2,:CONCERT3,:CONCERT4]

  #Burmy Field division (fuck burmy -Fal)
  PLANTCLOAK = [:GRASSY,:MISTY,:SWAMP,:RAINBOW,:FOREST,:WATERSURFACE,:UNDERWATER,:FAIRYTALE,:FLOWERGARDEN1,:FLOWERGARDEN2,:FLOWERGARDEN3,:FLOWERGARDEN4,:FLOWERGARDEN5,:STARLIGHT,:BEWITCHED,:SKY,:CLOUDS]
  SANDYCLOAK = [:DARKCRYSTALCAVERN,:BURNING,:VOLCANIC,:DESERT,:ICY,:ROCKY,:SUPERHEATED,:VOLCANICTOP,:ASHENBEACH,:CAVE,:CRYSTALCAVERN,:MOUNTAIN,:SNOWYMOUNTAIN,:DRAGONSDEN,:INFERNAL,:COLOSSEUM,:DEEPEARTH]
  TRASHCLOAK = [:ELECTERRAIN,:CHESS,:BIGTOP,:CORROSIVE,:CORROSIVEMIST,:FACTORY,:SHORTCIRCUIT,:WASTELAND,:GLITCH,:MURKWATERSURFACE,:HOLY,:MIRROR,:NEWWORLD,:INVERSE,:PSYTERRAIN,:DIMENSIONAL,:FROZENDIMENSION,:HAUNTED,:CORRUPTED,:CONCERT1,:CONCERT2,:CONCERT3,:CONCERT4,:CROWD,:DANCEFLOOR,:DARKNESS1,:DARKNESS2,:DARKNESS3]

  # Fieldconstant names for Reborn until field are sorted out there
  # can be removed afterwards
  NONE = 0
	ELECTRICT = 1
	GRASSYT = 2
	MISTYT = 3
	DARKCRYSTALC = 4
	CHESSB = 5
	BIGTOPA = 6
	BURNINGF = 7
	SWAMPF = 8
	RAINBOWF = 9
	CORROSIVEF = 10
	CORROSIVEMISTF = 11
	DESERTF = 12
	ICYF = 13
	ROCKYF = 14
	FORESTF = 15
	SUPERHEATEDF = 16
	FACTORYF = 17
	SHORTCIRCUITF = 18
	WASTELAND = 19
	ASHENB = 20
	WATERS = 21
	UNDERWATER = 22
	CAVE = 23
	GLITCHF = 24
	CRYSTALC = 25
	MURKWATERS = 26
	MOUNTAIN = 27
	SNOWYM = 28
	HOLYF = 29
	MIRRORA = 30
	FAIRYTALEF = 31
	DRAGONSD = 32
	FLOWERGARDENF = 33
	STARLIGHTA = 34
	NEWW = 35
	INVERSEF = 36
	PSYCHICT = 37
  INDOORA = 38
	INDOORB = 39
	INDOORC = 40
	CITY = 41
	CITYNEW = 42

end